<?php
declare(strict_types=1);

function auth_user(): ?array {
  return $_SESSION['user'] ?? null;
}

function auth_require(): array {
  $u = auth_user();
  if (!$u) redirect('/public/index.php?page=login');
  return $u;
}

function auth_is_role(string $role): bool {
  $u = auth_user();
  return $u && ($u['role'] === $role || $u['role'] === 'admin');
}

function auth_login(PDO $db, string $email, string $password): ?array {
  $user = db_one($db, "SELECT id,name,email,password_hash,role FROM users WHERE email = ?", [$email]);
  if (!$user) return null;
  if (!password_verify($password, $user['password_hash'])) return null;

  unset($user['password_hash']);
  $_SESSION['user'] = $user;
  return $user;
}

function auth_register(PDO $db, string $name, string $email, string $password): ?string {
  $exists = db_one($db, "SELECT id FROM users WHERE email = ?", [$email]);
  if ($exists) return "Email já cadastrado.";

  $hash = password_hash($password, PASSWORD_DEFAULT);
  $id = db_exec($db, "INSERT INTO users (name,email,password_hash,role) VALUES (?,?,?, 'buyer')", [$name,$email,$hash]);
  return null;
}

function auth_logout(): void {
  unset($_SESSION['user']);
}
