<?php
declare(strict_types=1);

session_start();

$configPath = __DIR__ . '/../config/config.php';
if (!file_exists($configPath)) {
  http_response_code(500);
  echo "Config não encontrado. Copie config/config.example.php para config/config.php e configure.";
  exit;
}
$config = require $configPath;

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/helpers.php';

$db = db_connect($config['DB']);

