<?php
// $view, $config, $user, etc.
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= e($config['APP_NAME']) ?></title>
  <link rel="stylesheet" href="/public/assets/styles.css">
</head>
<body>
  <div class="nav">
    <div class="brand">
      <a class="pill" href="/public/index.php?page=home"><?= e($config['APP_NAME']) ?></a>
      <a class="pill" href="/public/index.php?page=cart">Carrinho <span class="badge" data-cart-badge>0</span></a>
      <?php if ($user): ?>
        <a class="pill" href="/public/index.php?page=orders">Meus pedidos</a>
        <a class="pill" href="/public/index.php?page=seller">Vender</a>
      <?php endif; ?>
    </div>

    <div class="row">
      <?php if (!$user): ?>
        <a class="pill" href="/public/index.php?page=login">Entrar</a>
        <a class="pill" href="/public/index.php?page=register">Criar conta</a>
      <?php else: ?>
        <span class="pill">Olá, <?= e($user['name']) ?> (<?= e($user['role']) ?>)</span>
        <a class="pill" href="/public/index.php?page=logout">Sair</a>
      <?php endif; ?>
    </div>
  </div>

  <div class="container">
    <?php require __DIR__ . '/' . $view . '.php'; ?>
    <div class="footer muted">
      MVP Cidade Shop — pronto para evoluir (entrega, chat, fotos, etc.)
    </div>
  </div>

  <script src="/public/assets/app.js"></script>
</body>
</html>
